#pragma once
#include "afxwin.h"

typedef struct _SCHEDULE_INFO
{
	ULONG						nFrequencyType;			// 0 = ONCE / 1 = DAILY / 2 = WEEKLY
	
	SYSTEMTIME				sStartTime;

	ULONGLONG				nStartTime;

	SYSTEMTIME				sStopTime;

	ULONGLONG				nStopTime;

	ULONG						nWeeklyDay;				// 0 = Sunday, 1 = Monday, 2 = Tuesday, 3 = Wednesday, 4 = Thursday, 5 = Friday,  6 = Saturday

	//ULONG						nAfterRecording;			// 0 = NO ACTION / 1 = CLOSE / 2 = SHUT DOWN / 3 = SLEEP / 4 = HIBERNATE

	ULONG						nSkip;							// 0 = NO / 1 = YES

	BOOL							bIsRecording;

} SCHEDULE_INFO;

// CSchduleRecordDlg dialog

class CSchduleRecordDlg : public CDialogEx
{
	DECLARE_DYNAMIC(CSchduleRecordDlg)

public:
	CSchduleRecordDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CSchduleRecordDlg();

// Dialog Data
	//{{AFX_DATA(CMapLayerDlg)
	enum { IDD = IDD_DIALOG_SCHEDULE_RECORDING };	
	CListCtrl				m_ListScheduleInfo;
	CComboBox		m_comboboxFrequency;
	CComboBox		m_comboboxWeekly;
	CTime					m_timeDaily;
	CTime					m_timeStartTime;
	CTime					m_timeStopTime;
	//}}AFX_DATA

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:	

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnBnClickedBtnInsert();
	afx_msg void OnBnClickedBtnDelete();
	afx_msg void OnBnClickedCancel();
	afx_msg void OnBnClickedOk();
	DECLARE_MESSAGE_MAP()

public:

	int																						m_nChannelID;
		
	// SCHEDULE RECORDING
	//
	CArray<SCHEDULE_INFO, SCHEDULE_INFO>				m_oScheduleArray[ MAX_CHANNEL ];

	CRITICAL_SECTION															m_hScheduleArrayAccessCriticalSection[ MAX_CHANNEL ];
};
